#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"

uint32_t sysClock = 0;

// Using MOSC 16MHz (External) Direct
// void systemClockConfig (void)
// {
//     SysCtlClockSet(SYSCTL_XTAL_16MHZ|SYSCTL_USE_OSC|SYSCTL_OSC_MAIN);
// }

// Using PIOSC(Iternal) 16MHz Direct
// void systemClockConfig (void)
// {
//     SysCtlClockSet(SYSCTL_OSC_INT|SYSCTL_USE_OSC);
// }

// Using PLL 16MHz(External) -> 200 -> 80MHz
void systemClockConfig (void)
{
    SysCtlClockSet(SYSCTL_OSC_MAIN|SYSCTL_USE_PLL|SYSCTL_XTAL_16MHZ|SYSCTL_SYSDIV_2_5);
}

int main()
{
    systemClockConfig();
    sysClock = SysCtlClockGet();

    while (1){
         SysCtlDelay(sysClock);
    }
}
